/*
 *  SecuDE Release 4.1 (GMD)
 */
/********************************************************************
 * Copyright (C) 1991, GMD. All rights reserved.                    *
 *                                                                  *
 *                                                                  *
 *                         NOTICE                                   *
 *                                                                  *
 *    Acquisition, use, and distribution of this module             *
 *    and related materials are subject to restrictions             *
 *    mentioned in each volume of the documentation.                *
 *                                                                  *
 ********************************************************************/
#ifdef MAC
#include <stdlib.h>
#include <string.h>
#endif 

#include "psap.h"
#include "af.h"
#ifdef TEST
#include <stdio.h>
#endif

extern PE	pe_alloc ();	   /* from isode/psap.h */
extern int	pe_free ();	   /* from isode/psap.h */
extern int	pe_cmp ();	   /* from isode/psap.h */
extern PE	pe_cpy ();	   /* from isode/psap.h */

extern ObjId *aux_keyword2oid();
extern ObjId *aux_keyword2syntaxoid();
extern char	*aux_oid2keyword();


/* length of char string error message: */
#define  ERR_LEN 160

/* #define  OK           0  */
#define  BAD_ADDRESS -1

static char	* Equal_string = "=" ;
static char	* strong_Delimiter_string = "; " ;
static char	* weak_Delimiter_string = "% " ;

extern PE str2prim ();
extern void advise ();

extern void aux_free_DName ();

DName  * DName_comp_new ();
DName  * aux_Name2DName ();
RDName * str2RDName_aux ();
RDName * str2RDName ();
void     aux_append_RDName ();
void     aux_append_DName ();


/************* local functions: ******************************/

static
void  Bld_ava (key, attr, Ava, rc)
char	*key, *attr;
struct type_IF_AttributeValueAssertion **Ava;
int	*rc;
{
	ObjId * at;                   /* AttributeType */
	PE av     = NULLPE;       /* storage for printable string AttributeValue */
	int	avlen = strlen(attr); /* length of   printable string AttributeValue */
	char	*proc = "Bld_ava";

	/* *rc=OK set by calling routine str2RDName_aux() */

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (  (at = aux_keyword2oid(key)) == (ObjId * )0 ) {
		*rc = BAD_ADDRESS;
	} else {		/* legal keyword */
		if (*attr) 		 /* keyword value not empty */
			av = prts2prim(attr, avlen);
		else
			*rc = BAD_ADDRESS;

		if ( *rc == OK ) {
			(*Ava) = (struct type_IF_AttributeValueAssertion *)malloc(
			    sizeof(struct type_IF_AttributeValueAssertion ) );
			if (!(*Ava)) {
				aux_add_error(EMALLOC, "(*Ava)", CNULL, 0, proc);
				*rc = -1;
				return;
			}
			(*Ava)->element_IF_0 = (OIDentifier * )at;
			(*Ava)->element_IF_1 = av;
		}
	}   /*end else "legal keyword"*/
}


/************* external functions: ***************************/

/************* char string subfunctions imported**************/
/************* from EAN Version 1 str.h/str.c   **************/

char*
cpystr( /* char *str */ );

int catstr( /* char **ptr_str, int *ptr_len, char *new */);

char*
str_up( /* char *str */ );


/****************************************************************/


RDName *str2RDName_aux (str)
char	*str;
{
	char	*ptr, *save, val;
	char	*key, *value;
	char	*pbuff;
	RDName * rdn;
	struct type_IF_AttributeValueAssertion *Ava;
	int	rc;
	ObjId * syntax_oid;
	char	*proc = "str2RDName_aux";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	Ava = (struct type_IF_AttributeValueAssertion * ) 0;

	/* look for "type = value" */

	if (str == NULLCP) {
		aux_add_error(EINVALID, "NULL rdn component", CNULL, 0, proc);
		return (NULLRDNAME);
	}

	rc = OK;

	if ((ptr = strchr(str, *Equal_string)) == CNULL) {
		aux_add_error(EINVALID, "Equals missing in RDN", str, char_n, proc);
		return (NULLRDNAME);
	}


	save = ptr;
	val = *save;
	*ptr = '\0';
	ptr++;

	while (*str == ' ' || *str == '\t')
		str++;
	key = str;

	if (*ptr == 0) {
		aux_add_error(EINVALID, "Attribute Value missing in RDN", str, char_n, proc);
		*save = val;
		return (NULLRDNAME);
	}

	key = str_up(key);
	value = ptr;

	/* 'key = value' parsed */


	/* check up syntax of value */

	syntax_oid = aux_keyword2syntaxoid(key);
	if (!aux_cmp_ObjId(syntax_oid, CountryString)) {
/*
		if (!aux_check_3166(value)) {
			aux_add_error(EINVALID, "Invalid country code", value, char_n, proc);
			*save = val;
			return (NULLRDNAME);
		}
*/
		if (strlen (value) != 2) {
			aux_add_error(EINVALID, "Country code size wrong", value, char_n, proc);
			*save = val;
			return (NULLRDNAME);
		}
		if (islower ((u_char) value[0]))
			value[0] = toupper (value[0]);
		if (islower ((u_char) value[1]))
			value[1] = toupper (value[1]);
	}
	if (!aux_cmp_ObjId(syntax_oid, PrintableString) || !aux_cmp_ObjId(syntax_oid, CaseIgnoreString)) {
		if (!aux_check_print_string(value)) {
			aux_add_error(EINVALID, "No printable string", CNULL, 0, proc);
			*save = val;
			return (NULLRDNAME);
		}
	}

	Bld_ava (key, value, &Ava, &rc);

	if (rc == OK) {    /* build RDN consisting of one Ava */

		rdn = (struct type_IF_RelativeDistinguishedName *)malloc(
		    sizeof(struct type_IF_RelativeDistinguishedName ) );
		if (!rdn) {
			aux_add_error(EMALLOC, "rdn", CNULL, 0, proc);
			*save = val;
			return(NULLRDNAME);
		}
		rdn->next = NULLRDNAME;
		rdn->member_IF_0 = Ava;
	} 
	else {
		*save = val;
		aux_add_error(EINVALID, "Bld_ava failed", CNULL, 0, proc);
		return (NULLRDNAME);
	}

	*save = val;
	return (rdn);
}


/****************************************************************/


void aux_append_RDName (a, b)
RDName *a, *b;
{
	register RDName *ptr;
	register RDName *eptr;
	char	*pbuff;
	char	*proc = "aux_append_RDName";

	if (a == NULLRDNAME) {
		aux_add_error(EINVALID, "appending to null rdn", CNULL, 0, proc);
		return;
	} 

	for (eptr = a; eptr != NULLRDNAME; eptr = eptr->next)
		ptr = eptr;
	ptr->next = b;

	return;
}


/****************************************************************/


RDName *str2RDName (str)
char	*str;
{
	register char	* ptr, * save, val;
	RDName          * rdn = NULLRDNAME, * newrdn;
	char	        * proc = "str2RDName";

	/* look for "rdn % rdn % rdn" */

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (str == NULLCP)
		return (NULLRDNAME);

	while ( (ptr = strchr (str, *weak_Delimiter_string)) != CNULL) {
		save = ptr;
		val = *save;
		*ptr = '\0';
		ptr++;

		if ((newrdn = str2RDName_aux (str)) == NULLRDNAME) {
			if(rdn) free (rdn);
			*save = val;
			return (NULLRDNAME);
		}

		if ( rdn == NULLRDNAME )
			rdn = newrdn;
		else
			aux_append_RDName(rdn, newrdn);

		*save = val;
		str = ptr;
	}

	if ((newrdn = str2RDName_aux (str)) == NULLRDNAME) {
		if(rdn) free (rdn);
		return (NULLRDNAME);
	}

	if ( rdn == NULLRDNAME )
		rdn = newrdn;
	else
		aux_append_RDName(rdn, newrdn);

	return (rdn);
}


/****************************************************************/


DName *aux_Name2DName (str)
register char	*str;
{
	register char	*ptr, *save, val;
	DName   * dn = NULLDNAME, *newdn;
	RDName  * rdn;
	char	* SkipSpace ();
	char	* proc = "aux_Name2DName";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (str == NULLCP)
		return (NULLDNAME);

	if (*str == *strong_Delimiter_string)
		str++;		/* Skip leading ';' signs */

	while ( (ptr = strchr (str, *strong_Delimiter_string)) != CNULL) {
		save = ptr;
		val = *save;
		*ptr = '\0';
		ptr++;

		if ((rdn = str2RDName (str)) == NULLRDNAME) {
			aux_free_DName (&dn);
			*save = val;
			return (NULLDNAME);
		}
		if (dn == NULLDNAME)
			dn = DName_comp_new (rdn);
		else
			aux_append_DName (dn, DName_comp_new (rdn));

		*save = val;
		str = ptr;
	}


	if ((rdn = str2RDName (str)) == NULLRDNAME) {
		aux_free_DName (&dn);
		return (NULLDNAME);
	}

	if (dn == NULLDNAME)
		dn = DName_comp_new (rdn);
	else
		aux_append_DName (dn, DName_comp_new (rdn));

	return (dn);
}


/****************************************************************/


void aux_append_DName (a, b)
DName *a, *b;
{
	register DName *ptr;
	register DName *eptr;
	char	*pbuff;
	char	*proc = "aux_append_DName";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (a == NULLDNAME) {
		aux_add_error(EINVALID, "appending to null dn", CNULL, 0, proc);
		return;
	} 

	if (b == NULLDNAME) 
		return;
	for (eptr = a; eptr != NULLDNAME; eptr = eptr->next)
		ptr = eptr;
	ptr->next = b;

	return;
}


/****************************************************************/


DName  *DName_comp_new (rdn)
RDName *rdn;
{
	DName   * ptr;
	char	* proc = "DName_comp_new";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (!rdn) 
		return(NULLDNAME);
	ptr = (struct type_IF_Name *)malloc( sizeof(struct type_IF_Name ) );
	if (!ptr) {
		aux_add_error(EMALLOC, "ptr", CNULL, 0, proc);
		return(NULLDNAME);
	}
	ptr->element_IF_2 = rdn;
	ptr->next = NULLDNAME;
	return (ptr);
}


/****************************************************************/


char	*aux_DName2Name (name_ae)
DName  *name_ae;
{
	char	*name,  *tmp,  *keyword;
	int	len;
	int	flag;
	struct type_IF_AttributeValueAssertion *ava;
	RDName   * rdn;
	DName    * name_cur;
	PE av     = NULLPE;       /* storage for printable string AttributeValue */
	int	avlen = 0;            /* length of   printable string AttributeValue */
	char	* proc = "aux_DName2Name";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	name = cpystr ("");
	len  = strlen(name) + 1;

	if ( !name_ae ) 
		return (name) ;

	for ( name_cur = name_ae; name_cur; name_cur = name_cur->next ) {
		flag = 0;
		for ( rdn = name_cur->element_IF_2; rdn; rdn = rdn->next ) {
			if (( ava = rdn->member_IF_0 )) {
				keyword = aux_oid2keyword(ava->element_IF_0);
				if (flag) 
					catstr(&name, &len, weak_Delimiter_string);
				if (!flag ) 
					flag = 1;
				if (keyword) {
					catstr (&name, &len, keyword );
					catstr (&name, &len, Equal_string);
				} else {
					catstr (&name, &len, "??");
					catstr (&name, &len, Equal_string);
				}

				tmp = prim2str( ava->element_IF_1, &avlen );
				catstr (&name, &len, tmp) ;
				if(tmp) free(tmp);

			}  /*if ava exists*/
		}  /*for all AVAs in one RDN*/
		if ( name_cur->next )
			catstr(&name, &len, strong_Delimiter_string);
	}  /*for all RDNs in one Name*/

	return( name );
}

/****************************************************************/


char	* aux_DName2Attr (name_ae, attr_key)
DName   * name_ae;
char    * attr_key;
{
	char	*keyword;
	int	len;
	struct type_IF_AttributeValueAssertion *ava;
	RDName   * rdn;
	DName    * name_cur;
	PE av     = NULLPE;       /* storage for printable string AttributeValue */
	int	avlen = 0;            /* length of   printable string AttributeValue */
	char	* proc = "aux_DName2Attr";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if ( !name_ae || !attr_key)	
		return (CNULL);

	for ( name_cur = name_ae; name_cur; name_cur = name_cur->next ) {
		for ( rdn = name_cur->element_IF_2; rdn; rdn = rdn->next ) {
			if (( ava = rdn->member_IF_0 )) {
				keyword = aux_oid2keyword(ava->element_IF_0);
        			if (keyword) if(!strcmp(keyword, attr_key)) return(prim2str(ava->element_IF_1, &avlen));
			}  /*if ava exists*/
		}  /*for all AVAs in one RDN*/
	}  /*for all RDNs in one Name*/

	return (CNULL);
}


/****************************************************************/


DName *aux_ORName2DName (str)
register char	*str;
{
	register char	*ptr, *save, val;
	DName * dn = NULLDNAME, *newdn;
	RDName * rdn;
	char	* SkipSpace ();
	char	* proc = "aux_ORName2DName";
	
#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	if (str == NULLCP)
		return (NULLDNAME);

	if (*str == *strong_Delimiter_string)
		str++;		/* Skip leading ';' signs */

	while ( (ptr = strchr (str, *strong_Delimiter_string)) != CNULL) {
		save = ptr;
		val = *save;
		*ptr = '\0';
		ptr++;

		rdn = str2RDName (str);

		if (dn == NULLDNAME)
			dn = DName_comp_new (rdn);
		else
			aux_append_DName (dn, DName_comp_new (rdn));

		*save = val;
		str = ptr;
	}


	rdn = str2RDName (str);

	if (dn == NULLDNAME)
		dn = DName_comp_new (rdn);
	else
		aux_append_DName (dn, DName_comp_new (rdn));

	return (dn);
}



/****************************************************************/


char  * aux_DName2CAPITALName (name_ae)
DName * name_ae;
{
	char	* name,  * tmp, * keyword;
	int	  len;
	int	  flag;
	struct type_IF_AttributeValueAssertion * ava;
	RDName  * rdn;
	DName   * name_cur;
	PE        av = NULLPE;       /* storage for printable string AttributeValue */
	int	  avlen = 0;            /* length of   printable string AttributeValue */
	char	* proc = "aux_DName2CAPITALName";

#ifdef TEST
	fprintf(stderr, "%s\n", proc);	
#endif

	name = cpystr ("");
	len  = strlen(name) + 1;

	if ( !name_ae ) 
		return (name) ;

	for ( name_cur = name_ae; name_cur; name_cur = name_cur->next ) {
		flag = 0;
		for ( rdn = name_cur->element_IF_2; rdn; rdn = rdn->next ) {
			if (( ava = rdn->member_IF_0 )) {
				keyword = aux_oid2keyword(ava->element_IF_0);
				if (flag) 
					catstr(&name, &len, weak_Delimiter_string);
				if (!flag ) 
					flag = 1;
				if (keyword) {
					catstr (&name, &len, keyword );
					catstr (&name, &len, Equal_string);
				} else {
					catstr (&name, &len, "??");
					catstr (&name, &len, Equal_string);
				}

				tmp = prim2str( ava->element_IF_1, &avlen );
				tmp = str_up(tmp);
				catstr (&name, &len, tmp) ;
				if(tmp) free(tmp);

			}  /*if ava exists*/
		}  /*for all AVAs in one RDN*/
		if ( name_cur->next )
			catstr(&name, &len, strong_Delimiter_string);
	}  /*for all RDNs in one Name*/

	return( name );
}
